﻿Import-Module WebAdministration

$results = @()
foreach($WebSite in $(get-website))
{
  $logFile="$($Website.logFile.directory)\w3svc$($website.id)".replace("%SystemDrive%",$env:SystemDrive)
  $log=Get-ChildItem $logFile | Sort-Object LastAccessTime | Select-Object -Last 1
  $obj = [PSCustomObject]@{
    'WebSiteName' = $WebSite.name
    'LogFile' = $log.FullName
  }
  $results += $obj
}

$results | ConvertTo-Json -Compress