$cpu_counter = Get-WmiObject Win32_PerfFormattedData_PerfProc_Process | where-object{ $_.Name -ne "_Total" -and $_.Name -ne "Idle"} | Sort-Object PercentProcessorTime -Descending | select -First 10
$mem_counter = Get-WmiObject Win32_PerfFormattedData_PerfProc_Process | where-object{ $_.Name -ne "_Total" -and $_.Name -ne "Idle"} | Sort-Object workingset -Descending | select -First 10
#Write-Output $cpu_counter
#Write-Output $mem_counter

$cpu_data = @()
$mem_data = @()
$tot_data = @()

$tot_process = @()

#cpu
foreach ($item in $cpu_counter) {
    $cpu_data +=  @($item.name)
}
#Write-Output $cpu_data

#mem
foreach ($item in $mem_counter) {
    $mem_data +=  @($item.name)
}
#Write-Output $mem_data

$tot_data = $cpu_data + $mem_data | sort -unique
Write-Output $tot_data