#!/bin/bash

clear
set -e
sig_ver=1.0.11
zbx_ver=6.0.38
rpm_bit=`arch`
pkg_check=`which rpm >& /dev/null; echo $?`
sys_check=`which systemctl >& /dev/null; echo $?`
DATE=$(date +"%Y%m%d")
os=6

script_path=`dirname "$0"`
if [ $script_path == \. ]; then
    script_path=`pwd`
fi
dir="${script_path}/rpm"
echo $dir

cron_chk=`crontab -l >& /dev/null; echo $?`
if [ ${cron_chk} -eq 0 ]; then
    echo "========================================"
    echo "           Crontab List Backup          "
    echo "========================================"
    crontab -l > /dev/null 2>&1 > /tmp/crontab_$DATE.bak

    echo "========================================"
    echo "/tmp/crontab_$DATE.bak 파일 생성 완료 "
    echo "========================================"
fi

if [ ${pkg_check} -eq 0 ]; then #RPM PKG Check Point!!!
    echo ""
    echo ""
    echo "Can Use RPM Package."
    echo ""
    echo ""
    echo ""
    echo "========================================"
    echo "Server Information to Command List Check"
    echo "========================================"
    echo ""
    echo ""

    dmi_check=`which dmidecode >& /dev/null; echo $?`
    if [ ${dmi_check} -eq 1 ]; then
        echo ""
        echo ""
        echo "======================="
        echo " RPM Install Dmidecode "
        echo "======================="
        echo ""
        echo ""
        rpm -Uvh ${dir}/dmidecode-2.12-7.el${os}.${rpm_bit}.rpm
    elif [ ${dmi_check} -eq 0 ]; then
        echo "Dmidecode 가 이미 설치 되어 있습니다."
    fi

    zabbix_versionlock_check=`cat /etc/yum.conf | grep ^exclude=zabbix-agent >& /dev/null; echo $?`
    if [ ${zabbix_versionlock_check} -eq 1 ]; then
        echo ""
        echo ""
        echo "======================="
        echo " Zabbix update version lock "
        echo "======================="
        echo ""
        echo ""
        echo "exclude=zabbix-agent" >> /etc/yum.conf
    elif [ ${zabbix_versionlock_check} -eq 0 ]; then
        echo "/etc/yum.conf에 exclude=zabbix-agent 가 이미 추가되어 있습니다."
    fi

    zabbix_check=`rpm -qa |grep zabbix-agent >& /dev/null; echo $?`
    if [ ${zabbix_check} -eq 1 ]; then
        echo ""
        echo ""
        echo "=========================="
        echo " RPM Install zabbix-agent "
        echo "=========================="
        echo ""
        echo ""
        echo "OS version check!"
        echo "$os Version 사용중"
        rpm -Uvh --replacefiles ${dir}/zabbix-agent-$zbx_ver-release1.el${os}.${rpm_bit}.rpm

        chown root.root /var/log/zabbix
        chown root.root /var/run/zabbix
        echo "Zabbix Agent Install Complate!"
    elif [ ${zabbix_check} -eq 0 ]; then
        echo "Agent가 이미 설치 되어 있습니다."
        echo "기존 Agent 삭제 후 설치작업을 계속 진행 합니다."
        rpm -e zabbix-agent
        rpm -Uvh --replacefiles ${dir}/zabbix-agent-$zbx_ver-release1.el${os}.${rpm_bit}.rpm
        chown root.root /var/log/zabbix
        chown root.root /var/run/zabbix
        echo "Zabbix Agent Install Complate!"
    fi

    signal_check=`rpm -qa |grep signal365-conf >& /dev/null; echo $?`
    if [ ${signal_check} -eq 1 ]; then
        echo ""
        echo ""
        echo "============================"
        echo " RPM Install signal365-conf "
        echo "============================"
        echo ""
        echo ""
        rpm -ivh --replacefiles --nodeps ${dir}/signal365-conf-$sig_ver-1.${rpm_bit}.rpm
        echo " Signal365 Conf Install Complate! "
        echo ""
        echo ""
    elif [ ${signal_check} -eq 0 ]; then
        echo "Signal365 Config 가 이미 설치 되어 있습니다."
        sig_ver2=`rpm -qa |grep signal365 | awk -F- '{print $3}'`
        if [ ${sig_ver} == ${sig_ver2} ]; then
            echo "Signal365 최신 버전을 사용중입니다."
            echo ""
            echo ""
        else
            echo "Signal365 최신 버전으로 업데이트 합니다."
            rpm -Uvh --replacefiles --nodeps ${dir}/signal365-conf-$sig_ver-1.${rpm_bit}.rpm
            echo ""
            echo ""
        fi
    fi

    if [ -z $3 ] || [ $1 != '-c' ]; then
        echo ""
        echo ""
        echo " 설정 내용을 확인해주세요."
        echo ""
        echo ""
        echo "============================"
        echo "========================================"
        cat /etc/zabbix/zabbix_agentd.conf
        echo "========================================"
        echo "============================"
        echo ""
        echo ""
        echo " 입력한 내용이 맞습니까? (Y / N)"

        read yn
        case $yn in
        y|Y) echo "작업이 완료 되었습니다." ;;
        n|N)
            echo ""
            echo ""
            echo "Zabbix Server IP 를 입력해주세요."
            echo ":"
            read ip
            echo ""
            echo "Hostname 을 입력해주세요."
            echo ":"
            read hostname
            echo ""

            sed -i "s/Server=.*/Server=$ip/g" /etc/zabbix/zabbix_agentd.conf
            sed -i "s/ServerActive=.*/ServerActive=$ip/g" /etc/zabbix/zabbix_agentd.conf
            sed -i "s/Hostname=.*/Hostname=$hostname/g" /etc/zabbix/zabbix_agentd.conf

            echo ""
            echo ""
            echo "변경 내용을 확인해주세요."
            echo ""
            echo ""
            echo "========================================"
            cat /etc/zabbix/zabbix_agentd.conf
            echo "========================================"
            echo ""
            echo ""
            echo "작업이 완료 되었습니다." 
            ;;
        *) echo "잘못 입력하였습니다."
            exit 1 ;;
        esac
    else
        ip=$2
        hostname=$3
        sed -i "s/Server=.*/Server=$ip/g" /etc/zabbix/zabbix_agentd.conf
        sed -i "s/ServerActive=.*/ServerActive=$ip/g" /etc/zabbix/zabbix_agentd.conf
        sed -i "s/Hostname=.*/Hostname=$hostname/g" /etc/zabbix/zabbix_agentd.conf

        echo ""
        echo ""
        echo "변경 내용을 확인해주세요."
        echo ""
        echo ""
        echo "========================================"
        cat /etc/zabbix/zabbix_agentd.conf
        echo "========================================"
        echo ""
        echo ""
        echo "작업이 완료 되었습니다."

    fi

    echo ""
    echo ""
    echo "======================"
    echo " Agent 실행 계정 변경 "
    echo "======================"
    echo ""
    echo ""
    if [ ${sys_check} -eq 0 ]; then #Systemctl Check Point!!!
        echo ""
        echo ""
        echo "Can Use Systemctl Package."
        echo ""
        sed -i "s/User=.*/User=root/g" /usr/lib/systemd/system/zabbix-agent.service
        sed -i "s/Group=.*/Group=root/g" /usr/lib/systemd/system/zabbix-agent.service
        cat /usr/lib/systemd/system/zabbix-agent.service |grep root
        echo ""
        echo ""
        echo ""
        echo ""
        echo "======================"
        echo " Agent 를 실행합니다. "
        echo "======================"
        echo ""
        echo ""
        systemctl daemon-reload
        systemctl start zabbix-agent
        systemctl enable zabbix-agent
        sleep 1
        ps -ef |grep zabbix_agentd |grep -v "signal365"
        crond_chk=`crontab -l |grep Zabbix >& /dev/null; echo $?`
        if [ ${crond_chk} -eq 1 ]; then
            cat <(crontab -l) <(echo -e "# Zabbix Agent Restart\n0 0 1 * * systemctl restart zabbix-agent") | crontab -
            crontab -l
        elif [ ${crond_chk} -eq 0 ]; then
            crontab -l
        fi

    elif [ ${sys_check} -eq 1 ];
        then
        echo ""
        echo ""
        echo "Can Use Service Package."
        echo ""
        sed -i "s/ZABBIX_AGENT_USER=.*/ZABBIX_AGENT_USER=root/g" /etc/sysconfig/zabbix-agent
        cat /etc/sysconfig/zabbix-agent |grep root
        echo ""
        echo ""
        echo ""
        echo ""
        echo "======================"
        echo " Agent 를 실행합니다. "
        echo "======================"
        echo ""
        echo ""

        service zabbix-agent start
	chkconfig zabbix-agent on
        sleep 1
        ps -ef |grep zabbix_agentd |grep -v "signal365"
        crond_chk=`crontab -l |grep Zabbix >& /dev/null; echo $?`
        if [ ${crond_chk} -eq 1 ]; then
            cat <(crontab -l) <(echo -e "# Zabbix Agent Restart\n0 0 1 * * service zabbix-agent restart") | crontab -
            crontab -l
        elif [ ${crond_chk} -eq 0 ]; then
            crontab -l
        fi

    fi
    echo ""
    echo ""
    echo "========================="
    echo " 작업이 완료 되었습니다. "
    echo "========================="
    echo ""
    echo ""
fi
